% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_plots.R
\name{correlation.plots}
\alias{correlation.plots}
\title{Correlation plots between all samples}
\usage{
correlation.plots(
  df,
  output.dir,
  region = "mrna",
  type = "fpkm",
  height = 400,
  width = 400,
  size = 0.15,
  plot.ext = ".pdf",
  complex.correlation.plots = TRUE,
  data_for_pairs = countTable(df, region, type = type),
  as_gg_list = FALSE,
  text_size = 4,
  method = c("pearson", "spearman")[1]
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{output.dir}{directory to save to, named : cor_plot,
cor_plot_log2 and/or cor_plot_simple with either .pdf or .png}

\item{region}{a character (default: mrna), make raw count matrices of
whole mrnas or one of (leaders, cds, trailers)}

\item{type}{which value to use, "fpkm", alternative "counts".}

\item{height}{numeric, default 400 (in mm)}

\item{width}{numeric, default 400 (in mm)}

\item{size}{numeric, size of dots, default 0.15. Deprecated.}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".}

\item{complex.correlation.plots}{logical, default TRUE. Add in addition
to simple correlation plot two computationally heavy dots + correlation plots.
Useful for deeper analysis, but takes longer time to run, especially on low-quality
gpu computers. Set to FALSE to skip these.}

\item{data_for_pairs}{a data.table from ORFik::countTable of counts wanted.
Default is fpkm of all mRNA counts over all libraries.}

\item{as_gg_list}{logical, default FALSE. Return as a list of ggplot objects
instead of as a grob. Gives you the ability to modify plots more directly.}

\item{text_size}{size of correlation numbers}

\item{method}{c("pearson", "spearman")[1]}
}
\value{
invisible(NULL) / if as_gg_list is TRUE, return a list of raw plots.
}
\description{
Get correlation plot of raw counts and/or log2(count + 1) over
selected region in: c("mrna", "leaders", "cds", "trailers")\cr\cr
Note on correlation: Pearson correlation, using pairwise observations
to fill in NA values for the covariance matrix.
}
