% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORFs_helpers.R
\name{uniqueOrder}
\alias{uniqueOrder}
\title{Get unique ordering for GRangesList groups}
\usage{
uniqueOrder(grl)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}}}
}
\value{
an integer vector of indices of unique groups
}
\description{
This function can be used to calculate unique numerical identifiers
for each of the \code{\link{GRangesList}} elements. Elements of
\code{\link{GRangesList}} are unique when the \code{\link{GRanges}}
inside are not duplicated, so ranges differences matter as well as
sorting of the ranges.
}
\examples{
gr1 <- GRanges("1", IRanges(1,10), "+")
gr2 <- GRanges("1", IRanges(20, 30), "+")
# make a grl with duplicated ORFs (gr1 twice)
grl <- GRangesList(tx1_1 = gr1, tx2_1 = gr2, tx3_1 = gr1)
uniqueOrder(grl) # remember ordering

# example on unique ORFs
uniqueORFs <- uniqueGroups(grl)
# now the orfs are unique, let's map back to original set:
reMappedGrl <- uniqueORFs[uniqueOrder(grl)]
}
\seealso{
uniqueGroups

Other ORFHelpers: 
\code{\link{defineTrailer}()},
\code{\link{longestORFs}()},
\code{\link{mapToGRanges}()},
\code{\link{orfID}()},
\code{\link{startCodons}()},
\code{\link{startSites}()},
\code{\link{stopCodons}()},
\code{\link{stopSites}()},
\code{\link{txNames}()},
\code{\link{uniqueGroups}()}
}
\concept{ORFHelpers}
