% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateStatistics.R
\name{generateStatsReport}
\alias{generateStatsReport}
\title{Generate full output report plot document. Plots p-value histograms
for each contrast in the NormalyzerStatistics instance and writes these
to a PDF report.}
\usage{
generateStatsReport(
  nst,
  jobName,
  jobDir,
  sigThres = 0.1,
  sigThresType = "fdr",
  log2FoldThres = 0,
  plotRows = 3,
  plotCols = 4,
  writeAsPngs = FALSE
)
}
\arguments{
\item{nst}{NormalyzerDE statistics object.}

\item{jobName}{Name of processing run.}

\item{jobDir}{Path to output directory.}

\item{sigThres}{Significance threshold for indicating as significant}

\item{sigThresType}{Type of significance threshold (FDR or p)}

\item{log2FoldThres}{log2 fold-change required for being counted as significant}

\item{plotRows}{Number of plot rows.}

\item{plotCols}{Number of plot columns.}

\item{writeAsPngs}{Output the report as separate PNG files instead of a 
single PDF file}
}
\value{
None
}
\description{
Generate full output report plot document. Plots p-value histograms
for each contrast in the NormalyzerStatistics instance and writes these
to a PDF report.
}
\examples{
data(example_stat_summarized_experiment)
statObj <- NormalyzerStatistics(example_stat_summarized_experiment)
statObj <- calculateContrasts(statObj, comparisons=c("1-2", "2-3"), 
  condCol="group", type="limma")
outputDir <- tempdir()
generateStatsReport(statObj, "jobName", outputDir)
}
