% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/helper_methods.R
\name{newSim}
\alias{newSim}
\alias{newSim,newmodel-method}
\title{Simulate counts from a negative binomial model}
\usage{
newSim(object, seed, ...)

\S4method{newSim}{newmodel}(object, seed)
}
\arguments{
\item{object}{an object that describes a matrix of  negative
binomial.}

\item{seed}{an optional integer to specify how the random number generator
should be initialized with a call to \code{set.seed}. If missing, the
random generator state is not changed.}

\item{...}{additional arguments.}
}
\value{
A list with the following elements.
 \itemize{
 \item{counts}{the matrix with the simulated counts.}
 \item{dataNB}{the data simulated from the negative binomial.}
 \item{dataDropouts}{the data simulated from the binomial process.}
 \item{zeroFraction}{the fraction of zeros.}
 }
}
\description{
Given an object that describes negative binomial distribution,
simulate counts from the distribution.
}
\section{Methods (by class)}{
\itemize{
\item \code{newmodel}: simulate from a nb distribution.
}}

\examples{
a <- newmodel(n=5, J=10)
newSim(a)
}
