% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPath.R
\name{plotCytoscapeGML}
\alias{plotCytoscapeGML}
\title{Plots an annotated igraph object in Cytoscape.}
\usage{
plotCytoscapeGML(
  graph,
  file,
  layout = layout.auto,
  vertex.size,
  vertex.label,
  vertex.shape,
  vertex.color,
  edge.color
)
}
\arguments{
\item{graph}{An annotated igraph object.}

\item{file}{Output GML file name to which the network plot is exported.}

\item{layout}{Either a graph layout function, or a two-column matrix specifiying vertex coordinates.}

\item{vertex.size}{Vertex size. If missing, the vertex attribute "size" (\preformatted{V(g)$size)}) will be used.}

\item{vertex.label}{Vertex labels. If missing, the vertex attribute "label" (\preformatted{V(g)$label)}) will be used.
If missing, vertices are labeled by their name.}

\item{vertex.shape}{Vertex shape in one of igraph shapes. If missing, the vertex attribute "shape" (\preformatted{V(g)$shape)})
will be used. Shapes are converted from igraph convention to Cytoscape convention. "square","rectangle" and "vrectangle" are
converted to "RECT",  "csquare" and "crectangle" are converted to "ROUND_RECT", all other shapes are considered "ELLIPSE"}

\item{vertex.color}{A color or a list of colors for vertices. Vetices with multiple colors are not
supported. If missing, the vertex attribute "color" (\preformatted{V(g)$color)}) will be used.}

\item{edge.color}{A color or a list of colors for edges. If missing, the edge attribute "color"
(\preformatted{E(g)$color)}) will be used.}
}
\value{
For \code{plotCytoscapeGML}, results are written to file.
}
\description{
\code{plotCytoscape} function has been removed because RCytoscape is no longer prensent in Bioconductor.
Future plans will use RCy3 for Cytoscape plotting, once RCy3 is supported on MacOS and Windows.
\link{plotCytoscapeGML} exports the network plot in GML format, that can be later imported into Cytoscape
(using "import network from file" option). This fuction is compatible with all Cytoscape versions.
}
\examples{
 data("ex_sbml")
	rgraph <- makeReactionNetwork(ex_sbml, simplify=TRUE)
 v.layout <- layoutVertexByAttr(rgraph, "compartment")
	v.color <- colorVertexByAttr(rgraph, "compartment")

 # Export network plot to GML file
 plotCytoscapeGML(rgraph, file="example.gml", layout=v.layout,
				vertex.color=v.color, vertex.size=10)

}
\seealso{
Other Plotting methods: 
\code{\link{colorVertexByAttr}()},
\code{\link{layoutVertexByAttr}()},
\code{\link{plotAllNetworks}()},
\code{\link{plotClassifierROC}()},
\code{\link{plotClusterMatrix}()},
\code{\link{plotNetwork}()},
\code{\link{plotPathClassifier}()},
\code{\link{plotPaths}()}
}
\author{
Ahmed Mohamed
}
\concept{Plotting methods}
