% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeNanoStringSetFromEset.R
\name{makeNanoStringSetFromEset}
\alias{makeNanoStringSetFromEset}
\title{Convert NanoString ExpressionSet to NanoStringSet}
\usage{
makeNanoStringSetFromEset(eset, designs = NULL)
}
\arguments{
\item{eset}{NanoString data ExpressionSet, from processNanostringData}

\item{designs}{Design matrix. If NULL, will look for "groups" column in 
pData(eset).}
}
\value{
A NanoStringSet for NanoStringDiff
}
\description{
Convert ExpressionSet from processNanoStringData to a NanoStringSet for use
with the NanoStringDiff package.
}
\examples{
# Example data
example_data <- system.file("extdata", "GSE117751_RAW", package = "NanoTube")
sample_data <- system.file("extdata", "GSE117751_sample_data.csv", 
package = "NanoTube")

# Load data without normalization
dat <- processNanostringData(nsFiles = example_data,
                     sampleTab = sample_data, groupCol = "Sample_Diagnosis",
                     normalization = "none")
                     
# Convert to NanoStringSet
dat.ns <- makeNanoStringSetFromEset(dat)
}
