% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_region_heatmap.R
\name{plot_region_heatmap}
\alias{plot_region_heatmap}
\alias{plot_region_heatmap,NanoMethResult,character,numeric,numeric-method}
\alias{plot_region_heatmap,ModBamResult,character,numeric,numeric-method}
\alias{plot_region_heatmap,NanoMethResult,factor,numeric,numeric-method}
\alias{plot_region_heatmap,ModBamResult,factor,numeric,numeric-method}
\title{Plot region methylation heatmap}
\usage{
plot_region_heatmap(x, chr, start, end, ...)

\S4method{plot_region_heatmap}{NanoMethResult,character,numeric,numeric}(
  x,
  chr,
  start,
  end,
  pos_style = c("to_scale", "compact"),
  window_prop = 0,
  subsample = 50
)

\S4method{plot_region_heatmap}{ModBamResult,character,numeric,numeric}(
  x,
  chr,
  start,
  end,
  pos_style = c("to_scale", "compact"),
  window_prop = 0,
  subsample = 50
)

\S4method{plot_region_heatmap}{NanoMethResult,factor,numeric,numeric}(
  x,
  chr,
  start,
  end,
  pos_style = c("to_scale", "compact"),
  window_prop = 0,
  subsample = 50
)

\S4method{plot_region_heatmap}{ModBamResult,factor,numeric,numeric}(
  x,
  chr,
  start,
  end,
  pos_style = c("to_scale", "compact"),
  window_prop = 0,
  subsample = 50
)
}
\arguments{
\item{x}{the NanoMethResult or ModBamResult object.}

\item{chr}{the chromosome to plot.}

\item{start}{the start of the plotting region.}

\item{end}{the end of the plotting region.}

\item{...}{additional arguments.}

\item{pos_style}{the style for plotting the base positions along the x-axis.
Defaults to "to_scale", plotting (potentially) overlapping squares
along the genomic position to scale. The "compact" options plots only the
positions with measured modification.}

\item{window_prop}{the size of flanking region to plot. Can be a vector of two
values for left and right window size. Values indicate proportion of region
length.}

\item{subsample}{the number of read of packed read rows to subsample to.}
}
\value{
a ggplot object of the heatmap.

a ggplot plot containing the heatmap.
}
\description{
Plot the methylation heatmap of a genomic region.
}
\details{
This function creates a heatmap visualization of methylation data for a specified
genomic region. Each row represents one or more packed reads, with colored segments
indicating methylation probability at each position. Reads are packed vertically
to minimize plot height while avoiding overlaps.
}
\examples{
nmr <- load_example_nanomethresult()
plot_region_heatmap(nmr, "chr7", 6703892, 6730431)

}
