% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_agg_genes.R
\name{plot_agg_genes}
\alias{plot_agg_genes}
\title{Plot gene aggregate plot}
\usage{
plot_agg_genes(
  x,
  genes = NULL,
  binary_threshold = 0.5,
  group_col = NULL,
  flank = 2000,
  stranded = TRUE,
  span = 0.05,
  palette = ggplot2::scale_colour_brewer(palette = "Set1")
)
}
\arguments{
\item{x}{the NanoMethResult or ModBamResult object.}

\item{genes}{a character vector of gene symbols to include in aggregate plot.
If NULL (default), all genes in exons(x) are used.}

\item{binary_threshold}{the modification probability such that calls with
modification probability above the threshold are considered methylated, and
those with probability equal or below are considered unmethylated.}

\item{group_col}{the column name to group aggregated trends by. This column can
be found in either the regions table or samples(x). When NULL (default), all
data is aggregated together. Common values include "sample" to show individual
samples or "group" to show sample groups.}

\item{flank}{the number of flanking bases to add to each side of each region.}

\item{stranded}{if TRUE, negative strand features will have their coordinates
flipped to reflect biological features like transcription start sites
(e.g., for genes, coordinates run from TSS to TES regardless of strand).}

\item{span}{the span parameter for loess smoothing of the trend lines.}

\item{palette}{the ggplot colour palette used for groups.}
}
\value{
a ggplot object containing the aggregate methylation trend of genes.
}
\description{
Plot gene aggregate plot
}
\details{
This function creates an aggregate methylation profile across multiple genes by
scaling all genes to the same relative coordinates (0 to 1) and averaging
methylation levels at each relative position. Genes are optionally extended by
flanking regions specified by the flank parameter. The resulting plot shows
smoothed trends of average methylation probability from gene start to gene end,
with optional flanking regions.
}
\examples{
nmr <- load_example_nanomethresult()
plot_agg_genes(nmr)

# Plot specific genes only
plot_agg_genes(nmr, genes = c("Peg3", "Impact"))

# Group by sample
plot_agg_genes(nmr, group_col = "sample")

}
