% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_BS_genome.R
\name{find_BS_genome}
\alias{find_BS_genome}
\title{Find the appropriate BS genome for the specified organism and genome.}
\usage{
find_BS_genome(organism, genome, masked = FALSE)
}
\arguments{
\item{organism}{the name of the organism for which to install the reference
genome. This can be the scientific name or a common name. For example Homo
Sapiens, H. sapiens, or human}

\item{genome}{The reference genome assembly version. Ex. hg18, mm10, rn6.}

\item{masked}{Logical value. Whether to search for the 'masked' BSgenome.
Default is FALSE.}
}
\value{
a BSgenome package name or a dataframe of possibilities
}
\description{
This function will browse available BSgenomes, indicating
which one should be installed for the specified organism and genome assembly
version. If you cannot specify both organism and genome, the function can
return a list of available genomes for a specified species.
}
\examples{
# Find the reference genome for Mouse, mm10 assembly:
mouse_mm10 <- find_BS_genome("mouse", "mm10")
}
