% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset-methods.R
\name{subset-methods}
\alias{subset-methods}
\alias{[,MultimodalExperiment,ANY,ANY,ANY-method}
\alias{[}
\alias{[<-,MultimodalExperiment,ANY,ANY,ANY-method}
\alias{[<-}
\title{MultimodalExperiment Subset Methods}
\usage{
\S4method{[}{MultimodalExperiment,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{MultimodalExperiment,ANY,ANY,ANY}(x, i, j) <- value
}
\arguments{
\item{x}{a \linkS4class{MultimodalExperiment} object}

\item{i}{a \link[base:list]{list}, \link[S4Vectors:List-class]{List},
\link[IRanges:AtomicList-class]{LogicalList}, \link[IRanges:AtomicList-class]{IntegerList}, or
\link[IRanges:AtomicList-class]{CharacterList} of elements to extract or replace}

\item{j}{a \link[base:list]{list}, \link[S4Vectors:List-class]{List},
\link[IRanges:AtomicList-class]{LogicalList}, \link[IRanges:AtomicList-class]{IntegerList}, or
\link[IRanges:AtomicList-class]{CharacterList} of elements to extract or replace}

\item{...}{ignored, required by generic}

\item{drop}{ignored, required by generic}

\item{value}{a replacement value}
}
\value{
\code{[} returns a \linkS4class{MultimodalExperiment} object.
}
\description{
Extract or replace parts of a \linkS4class{MultimodalExperiment} object.
}
\examples{
ME <-
    MultimodalExperiment()

bulkExperiments(ME) <-
    ExperimentList(
        pbRNAseq = pbRNAseq
    )

singleCellExperiments(ME) <-
    ExperimentList(
        scADTseq = scADTseq,
        scRNAseq = scRNAseq
    )

subjectMap(ME)[["subject"]] <-
    "SUBJECT-1"

sampleMap(ME)[["subject"]] <-
    "SUBJECT-1"

cellMap(ME)[["sample"]] <-
    "SAMPLE-1"

ME <-
    propagate(ME)

experimentData(ME)[["published"]] <-
    c(NA_character_, "2018-11-19", "2018-11-19") |>
    as.Date()

subjectData(ME)[["condition"]] <-
    as.character("healthy")

sampleData(ME)[["sampleType"]] <-
    as.character("peripheral blood mononuclear cells")

cellType <- function(x) {
    if (x[["CD4"]] > 0L) {
        return("T Cell")
    }

    if (x[["CD14"]] > 0L) {
        return("Monocyte")
    }

    if (x[["CD19"]] > 0L) {
        return("B Cell")
    }

    if (x[["CD56"]] > 0L) {
        return("NK Cell")
    }

    NA_character_
}

cellData(ME)[["cellType"]] <-
    experiment(ME, "scADTseq") |>
    apply(2L, cellType)

i <-
    rownames(ME) |>
    endoapply(sample, 4L)

j <-
    colnames(ME) |>
    endoapply(sample, 1L)

ME[i, j] <-
    0L

experiment(ME[i, j], "pbRNAseq")

experiment(ME[i, j], "scADTseq")

experiment(ME[i, j], "scRNAseq")

}
\seealso{
\code{browseVignettes("MultimodalExperiment")}
}
