% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordination-methods.R
\name{coordination-methods}
\alias{coordination-methods}
\alias{propagate,MultimodalExperiment-method}
\alias{propagate}
\alias{harmonize,MultimodalExperiment-method}
\alias{harmonize}
\title{MultimodalExperiment Coordination Methods}
\usage{
\S4method{propagate}{MultimodalExperiment}(x)

\S4method{harmonize}{MultimodalExperiment}(x)
}
\arguments{
\item{x}{a \linkS4class{MultimodalExperiment} object}
}
\value{
\code{propagate} returns a \linkS4class{MultimodalExperiment} object.

\code{harmonize} returns a \linkS4class{MultimodalExperiment} object.
}
\description{
Propagate or harmonize indices of a \linkS4class{MultimodalExperiment} object.
}
\details{
\code{propagate} inserts experiment, subject, sample, and cell indices into all
relevant tables by taking their union and adding missing indices.

\code{harmonize} deletes experiment, subject, sample, and cell indices from all
relevant tables by taking their intersection and removing extraneous indices.
}
\examples{
ME <-
    MultimodalExperiment()

bulkExperiments(ME) <-
    ExperimentList(
        pbRNAseq = pbRNAseq
    )

singleCellExperiments(ME) <-
    ExperimentList(
        scADTseq = scADTseq,
        scRNAseq = scRNAseq
    )

subjectMap(ME)[["subject"]] <-
    "SUBJECT-1"

sampleMap(ME)[["subject"]] <-
    "SUBJECT-1"

cellMap(ME)[["sample"]] <-
    "SAMPLE-1"

ME <-
    propagate(ME)

experimentData(ME)[["published"]] <-
    c(NA_character_, "2018-11-19", "2018-11-19") |>
    as.Date()

subjectData(ME)[["condition"]] <-
    as.character("healthy")

sampleData(ME)[["sampleType"]] <-
    as.character("peripheral blood mononuclear cells")

cellType <- function(x) {
    if (x[["CD4"]] > 0L) {
        return("T Cell")
    }

    if (x[["CD14"]] > 0L) {
        return("Monocyte")
    }

    if (x[["CD19"]] > 0L) {
        return("B Cell")
    }

    if (x[["CD56"]] > 0L) {
        return("NK Cell")
    }

    NA_character_
}

cellData(ME)[["cellType"]] <-
    experiment(ME, "scADTseq") |>
    apply(2L, cellType)

isMonocyte <-
    cellData(ME)[["cellType"]] \%in\% "Monocyte"

cellData(ME) <-
    cellData(ME)[isMonocyte, , drop = FALSE]

harmonize(ME)

}
\seealso{
\code{browseVignettes("MultimodalExperiment")}
}
