% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCArealization.R
\name{PCArealization}
\alias{PCArealization}
\title{PCA realization}
\usage{
PCArealization(
  SEresNorm,
  DATAnorm = TRUE,
  gene.deletion = NULL,
  sample.deletion = NULL,
  Supp.del.sample = FALSE
)
}
\arguments{
\item{SEresNorm}{Results of the function
\code{\link[=DATAnormalization]{DATAnormalization()}}.}

\item{DATAnorm}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
\code{TRUE} means the function uses the normalized data.
\code{FALSE} means the function uses the raw counts data.}

\item{gene.deletion}{\code{NULL} or a vector of characters or a vector of
integers. \code{NULL} as default.
If \code{gene.deletion} is a vector of characters, all genes with names in
\code{gene.deletion} will be deleted from the data set as input
\code{RawCounts} of our function
\code{\link[=DATAprepSE]{DATAprepSE()}}.
If \code{gene.deletion} is a vector of integers,
all the corresponding row numbers will be deleted from the data set as input
\code{RawCounts} of our function
\code{\link[=DATAprepSE]{DATAprepSE()}}.
If \code{gene.deletion=NULL} all genes will be used in the construction
of the PCA.}

\item{sample.deletion}{\code{NULL} or a vector of characters or
a vector of integers. \code{NULL} as default.
If \code{sample.deletion} is a vector of characters, all samples with names
in \code{sample.deletion} will not be used in the construction of the PCA.
If \code{sample.deletion} is a vector of integers,
all the corresponding column numbers will not be used in the construction
of the PCA from the data set as input \code{RawCounts} of our function
\code{\link[=DATAprepSE]{DATAprepSE()}}.
If \code{sample.deletion=NULL} all samples will be used
in the construction of the PCA.}

\item{Supp.del.sample}{\code{TRUE} or \code{FALSE}. \code{FALSE} by default.
If \code{FALSE}, the samples selected with \code{sample.deletion} will
be deleted.
If \code{TRUE}, the samples selected with \code{sample.deletion} will
be plotted.
These individuals are called supplementary individuals in
\code{\link[FactoMineR:PCA]{FactoMineR::PCA()}}.}
}
\value{
The function returns the same SummarizedExperiment class object
\code{SEresNorm} but with the output of the
\code{\link[FactoMineR:PCA]{FactoMineR::PCA()}}
function (see
\code{\link[FactoMineR:PCA]{FactoMineR::PCA()}})
saved in the metadata \code{Results[[1]][[2]]} of \code{SEresNorm}.
}
\description{
From a gene expression dataset, the functions performs
the Principal Component Analysis (PCA) through the R function
\code{\link[FactoMineR:PCA]{FactoMineR::PCA()}}.
}
\details{
All results are built from the results of our function
\code{\link[=DATAnormalization]{DATAnormalization()}}.
}
\examples{
## Simulation raw counts
resSIMcount <- RawCountsSimulation(Nb.Group=2, Nb.Time=3, Nb.per.GT=4,
                                   Nb.Gene=10)
## Preprocessing step
resDATAprepSE <- DATAprepSE(RawCounts=resSIMcount$Sim.dat,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=2,
                            Individual.position=3)
## Normalization
resNorm <- DATAnormalization(SEres=resDATAprepSE,
                             Normalization="rle",
                             Plot.Boxplot=FALSE,
                             Colored.By.Factors=FALSE)
##------------------------------------------------------------------------##
resPCAex <- PCArealization(SEresNorm=resNorm,
                           DATAnorm=TRUE,
                           gene.deletion=c(3, 5),
                           sample.deletion=c("G1_t0_Ind2", "G1_t1_Ind3"),
                           Supp.del.sample=FALSE)
##------------------------------------------------------------------------##
resPCAex2 <- PCArealization(SEresNorm=resNorm,
                            DATAnorm=TRUE,
                            gene.deletion=c("Gene3", "Gene5"),
                            sample.deletion=c(3, 8),
                            Supp.del.sample=TRUE)
}
\seealso{
The \code{\link[=PCArealization]{PCArealization()}} function
\itemize{
\item is used by the following functions of our package :
\code{\link[=PCAanalysis]{PCAanalysis()}} and
\code{\link[=HCPCanalysis]{HCPCanalysis()}}.
\item calls the R function
\code{\link[=PCApreprocessing]{PCApreprocessing()}}
for reshaping the data and
uses its output for performing a Principal Component (PCA)
with
\code{\link[FactoMineR:PCA]{FactoMineR::PCA()}}.
}
}
