% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEplotVennBarplotTime.R
\name{DEplotVennBarplotTime}
\alias{DEplotVennBarplotTime}
\title{Venn barplot of DE genes across time.}
\usage{
DEplotVennBarplotTime(table.DE.time, Log2.FC.matrix)
}
\arguments{
\item{table.DE.time}{Binary matrix or data.frame (table filled with 0 and 1)
with \eqn{N_g} rows and \eqn{T-1} columns with \eqn{N_g} the number of genes
and \eqn{T} the number of time points.}

\item{Log2.FC.matrix}{Numeric matrix or data.frame with \eqn{N_g} rows and
\eqn{T-1} columns.}
}
\value{
The function plots
\itemize{
\item the number of genes per time patterns in an UpSet plot (Venn diagram
displayed as a barplot) with the R function \code{\link[UpSetR:upset]{UpSetR::upset()}}.
By temporal pattern, we mean the set of times ti such that the gene is
DE between ti and the reference time t0.
\item a similar UpSet plot where each bar is split in different colors
corresponding to all possible numbers of DE times where genes are over
expressed in a given temporal pattern.
}
}
\description{
The function takes as input two matrix or data.frame
\itemize{
\item a binary matrix or data.frame with \eqn{N_g} rows corresponding to genes
and \eqn{T-1} columns corresponding to times
(with \eqn{T} the number of time points).
A '1' in the n-th row and i-th column means that the n-th gene is
differentially expressed (DE) at time ti, compared with
the reference time t0.
\item a numeric matrix or data.frame with \eqn{N_g} rows corresponding to genes
and \eqn{T-1} columns corresponding to times.
The element in n-th row and i-th column corresponds to the \eqn{log_2}
fold change between the time ti and the reference time t0 for the n-th gene.
If the gene is DE and the sign is positive, then the gene n will be
considered as over-expressed (up-regulated) at time ti.
If the gene is DE and the sign is negative, then the gene n will be
considered as under-expressed (down-regulated) at time ti.
}
}
\examples{
set.seed(1994)
Nb.Time <- 4 ## Number of time measurement
##------------------------------------------------------------------------##
table.DE.time.ex <- matrix(sample(c(0,1), replace=TRUE,
                                  size=40*(Nb.Time-1), c(0.2, 0.8)),
                           ncol=Nb.Time-1)
colnames(table.DE.time.ex) <- paste0("t", seq_len(Nb.Time-1))
##------------------------------------------------------------------------##
Log2FC.mat.ex <- matrix(round(rnorm(n=40*(Nb.Time-1), mean=0, sd=1),
                              digits=2),
                        ncol=(Nb.Time-1))
colnames(Log2FC.mat.ex) <- paste0("t", seq_len(Nb.Time-1))
##------------------------------------------------------------------------##
res.test.VennBarplot <- DEplotVennBarplotTime(table.DE.time=table.DE.time.ex,
                                              Log2.FC.matrix=Log2FC.mat.ex)
print(res.test.VennBarplot$Upset.graph)
print(res.test.VennBarplot$Upset.graph.with.nb.over)
res.test.VennBarplot$DE.pattern.t.01.sum
}
\seealso{
The function
\itemize{
\item calls the function \code{\link[UpSetR:upset]{UpSetR::upset()}} in order to plot the UpSet plot.
\item is called by the functions \code{\link[=DEanalysisTime]{DEanalysisTime()}} and
\code{\link[=DEanalysisTimeAndGroup]{DEanalysisTimeAndGroup()}}.
}
}
