% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterNumbers.R
\name{CharacterNumbers}
\alias{CharacterNumbers}
\title{Transformation of a vector of integers into
a vector of class "character".}
\usage{
CharacterNumbers(Vect.number)
}
\arguments{
\item{Vect.number}{Vector of integers.}
}
\value{
A vector where each integer is transformed in class "character".
}
\description{
Transformation of a vector of integers into
a vector of class "character" so that lexicographic order of characters
corresponds to the numerical order of time measurements.
}
\details{
An appropriate number of character "0" is added in front of
the numerical characters corresponding to the decimal writing of
each integer in \code{Vect.number} so that the order of elements of
the vector is preserved. For example, "9">"11", but "09"<"11".
}
\examples{
CharacterNumbers(Vect.number=c(0,1,9,11,90,99,100,101))
CharacterNumbers(Vect.number=0:11)
CharacterNumbers(Vect.number=1:8)
}
\seealso{
The function is called by
\code{\link[=ColnamesToFactors]{ColnamesToFactors()}}.
}
