% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{batchEstPlot}
\alias{batchEstPlot}
\title{batchEstPlot}
\usage{
batchEstPlot(mbac, ...)
}
\arguments{
\item{mbac}{Object of class mbac generated by *createMbac*.}

\item{...}{Other graphical parameters.}
}
\value{
Batch estimation plot is displayed.
}
\description{
This function uses linear models to estimate the batch effect magnitude using the common data across batches. It compares
the result with theoretical distribution of diferrent levels of batch magnitude.
}
\examples{
data('multiyeast')

my_mbac <- createMbac (inputOmics = list(A.rna, A.gro, B.rna, B.ribo, C.rna, C.par),
                       batchFactor = c("A", "A", "B", "B", "C", "C"),
                       experimentalDesign = list("A" =  c("Glu+", "Glu+",
                       "Glu+", "Glu-", "Glu-", "Glu-"),
                       "B" = c("Glu+", "Glu+", "Glu-", "Glu-"),
                       "C" = c("Glu+", "Glu+", "Glu-", "Glu-")),
                       omicNames = c("RNA", "GRO", "RNA", "RIBO", "RNA", "PAR"))

batchEstPlot (my_mbac)

}
