% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARSyNbac.R
\name{ARSyNbac}
\alias{ARSyNbac}
\title{ARSyNbac}
\usage{
ARSyNbac(
  mbac,
  batchEstimation = TRUE,
  filterNoise = TRUE,
  Interaction = FALSE,
  Variability = 0.9,
  beta = 2,
  modelName = "Model 1",
  showplot = TRUE
)
}
\arguments{
\item{mbac}{mbac object generated by *createMbac*.}

\item{batchEstimation}{Logical. If TRUE (default) the batch effect is estimated and used to correct the data. Use TRUE when the source of the batch effect is known.}

\item{filterNoise}{Logical. If TRUE (default) structured noise is removed form residuals. Use this option when there is an unknown source of batch effect in data.}

\item{Interaction}{Logical. Whether to model the interaction between factors or not (FALSE by default).}

\item{Variability}{From 0 to 1. Minimum percent of data variability that must be explained by each model. By default, 0.90.}

\item{beta}{Numeric. Components that represent more than beta times the average variability are identified as systematic noise in residuals. Used in noise reduction mode. By default, 2.}

\item{modelName}{Name of the model created. This name will be showed if you use the explained_var plot function. By default, "Model 1".}

\item{showplot}{Logical. If TRUE (default), the explained_var plot is showed. This plot represents the number of components selected for the ARSyN model.}
}
\value{
Custom mbac object. Elements in a mbac object:
\enumerate{
    \item ListOfBatches: A list of MultiAssayExperiment objects (one per batch).
    \item commonOmic Name of the common omic between the batches. It must be one of the names in omicNames argument. If NULL (default), the omic names that appears more times is selected as commonOmic.
    \item CorrectedData: Same structure than ListOfBatches but with the corrected data instead of the original.
    \item ARSyNmodels: ARSyN models created during MultiBaC performance (one per omic data type).
}
}
\description{
ARSyNbac
}
\examples{
data('multiyeast')

my_mbac <- createMbac (inputOmics = list(A.rna, B.rna, C.rna),
                       batchFactor = c("A", "B", "C"),
                       experimentalDesign = list("A" =  c("Glu+",
                       "Glu+", "Glu+", "Glu-",
                       "Glu-", "Glu-"),
                       "B" = c("Glu+", "Glu+", "Glu-", "Glu-"),
                       "C" = c("Glu+", "Glu+", "Glu-", "Glu-")),
                       omicNames = "RNA")
my_final_mbac <- ARSyNbac (my_mbac, batchEstimation = TRUE, filterNoise = TRUE,
                  Interaction=TRUE, Variability = 0.90, beta = 2,
                  modelName = "Model 1",
                  showplot = FALSE)

}
\references{
Nueda MJ, Ferrer A, Conesa A. ARSyN: A method for the identification and removal of systematic noise in multifactorial time course microarray experiments. Biostatistics. 2012;13:553–66.
}
