% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prio.R
\name{prio}
\alias{prio}
\title{Prioritization of inbred mouse strains for refining genetic regions}
\usage{
prio(
  chr,
  start = NULL,
  end = NULL,
  strain1 = NULL,
  strain2 = NULL,
  consequence = NULL,
  impact = NULL,
  min_strain_benef = 0.1,
  max_set_size = 3,
  return_obj = "dataframe"
)
}
\arguments{
\item{chr}{Vector of chromosome names.}

\item{start}{Optional vector of chromosomal start positions of target regions
(GRCm38).}

\item{end}{Optional vector of chromosomal end positions of target regions
(GRCm38).}

\item{strain1}{First strain set with strains from avail_strains().}

\item{strain2}{Second strain set with strains from avail_strains().}

\item{consequence}{Optional vector of consequence types.}

\item{impact}{Optional vector of impact types.}

\item{min_strain_benef}{Minimum reduction factor (min) of a single strain.}

\item{max_set_size}{Maximum set of strains.}

\item{return_obj}{The user can choose to get the result to be returned
as data frame ("dataframe") or as a GenomicRanges::GRanges ("granges")
object. Default value is "data frame".}
}
\value{
Data frame
}
\description{
This method allows to select strain combinations which best
refine a specified genetic region (GRCm38). E.g. if a crossing experiment
with two inbred mouse strains 'strain1' and 'strain2' resulted in a QTL, the
outputted strain combinations can be used to refine the respective region in
further crossing experiments.
}
\examples{
res = prio("chr1",
  start = 5000000, end = 6000000, strain1 = "C57BL_6J",
  strain2 = "AKR_J"
)

comment(res$genotypes)
}
