% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_peak_file_macs.R
\name{read_peak_file_macs}
\alias{read_peak_file_macs}
\title{Read MACS2/3 narrowPeak peak file}
\usage{
read_peak_file_macs(peak_file)
}
\arguments{
\item{peak_file}{A character string with the path to the peak file, or a
GRanges object created using \code{\link[=read_peak_file]{read_peak_file()}}.}
}
\value{
A \link[GenomicRanges]{GRanges-class} object with the peak
coordinates and summit.
}
\description{
This function reads a MACS2/3 narrowPeak peak file and returns a GRanges
object with the peak coordinates and summit.
}
\details{
The \emph{summit} column is the absolute genomic position of the peak,
which is relative to the start position of the sequence range.
For SEACR BED files, the \emph{summit} column is calculated as the
midpoint of the max signal region.
}
\examples{
macs3_peak_file <- system.file("extdata", "CTCF_ChIP_peaks.narrowPeak",
package = "MotifPeeker")
macs3_peak_read <- read_peak_file(macs3_peak_file)
macs3_peak_read

}
\seealso{
\link[GenomicRanges]{GRanges-class} for more information on GRanges
objects.
}
\keyword{internal}
