% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ENCODE.R
\name{check_ENCODE}
\alias{check_ENCODE}
\title{Check for ENCODE input}
\usage{
check_ENCODE(encode_id, expect_format, verbose = FALSE)
}
\arguments{
\item{encode_id}{A character string specifying the ENCODE ID.}

\item{expect_format}{A character string (or a vector) specifying the expected
format(s) of the file. If the file is not in the expected format, an error is
thrown.}

\item{verbose}{A logical indicating whether to print verbose messages while
running the function. (default = FALSE)}
}
\value{
A character string specifying the path to the downloaded file.
}
\description{
Check and get files from ENCODE project. Requires the input to be in ENCODE
ID format. Uses BiocFileCache to cache downloads. Only works for files.
}
\examples{
if (requireNamespace("curl", quietly = TRUE) &&
    requireNamespace("jsonlite", quietly = TRUE)) {
    check_ENCODE("ENCFF920TXI", expect_format = c("bed", "gz"))
}

}
