% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLS.R
\name{GLS}
\alias{GLS}
\title{GLS
This function carries out gene literature search.}
\usage{
GLS(genes, query_string = "AND cancer AND driver")
}
\arguments{
\item{genes}{A character string containing the genes
to search in PubMed database}

\item{query_string}{A character string containing words
in query to follow the gene of interest. Default is
"AND cancer AND driver" resulting in a final query of
"Gene AND cancer AND driver". Standard PubMed syntax
can be used in the query. For example Boolean operators
AND, OR, NOT can be applied and tags such as [AU],
[TITLE/ABSTRACT], [Affiliation] can be used.}
}
\value{
A tibble containing results of literature search
where PubMed was queried for information of input genes.
Each row in the tibble contains a PubMed ID matching the
query, doi, title, abstract, year of publication, mesh_terms,
and total number of PubMed publications, resulting in a
total of eight columns.
}
\description{
GLS
This function carries out gene literature search.
}
\examples{
genes_query <- "ABCG2"
dataGLS <- GLS(genes = genes_query,
              query_string = "AND cancer AND driver AND
              '2020/01/01'[Date - Publication] : '2025/01/01'[Date - Publication]")
}
