% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Modstrings-separate.R
\name{separate}
\alias{separate}
\alias{combineIntoModstrings}
\alias{combineModifications}
\alias{incompatibleModifications}
\alias{removeIncompatibleModifications}
\alias{separate,ModString-method}
\alias{separate,ModStringSet-method}
\alias{separate,GRanges-method}
\alias{separate,GRangesList-method}
\alias{combineIntoModstrings,XString,GRanges-method}
\alias{combineIntoModstrings,XStringSet,GRangesList-method}
\alias{combineIntoModstrings,XStringSet,GRanges-method}
\alias{combineModifications,GRanges-method}
\alias{combineModifications,GRangesList-method}
\alias{incompatibleModifications,GRanges,XString-method}
\alias{incompatibleModifications,GRanges,XStringSet-method}
\alias{incompatibleModifications,GRangesList,XStringSet-method}
\alias{removeIncompatibleModifications,GRanges,XString-method}
\alias{removeIncompatibleModifications,GRanges,XStringSet-method}
\alias{removeIncompatibleModifications,GRangesList,XStringSet-method}
\title{Separating and combining a modification information into/from a
  \code{XString} and a \code{GRanges} object}
\usage{
separate(x, nc.type = "short")

combineIntoModstrings(
  x,
  gr,
  with.qualities = FALSE,
  quality.type = "Phred",
  stop.on.error = TRUE,
  verbose = FALSE,
  ...
)

combineModifications(gr, ...)

incompatibleModifications(gr, x, ...)

removeIncompatibleModifications(gr, x, ...)

\S4method{separate}{ModString}(x, nc.type = c("short", "nc"))

\S4method{separate}{ModStringSet}(x, nc.type = c("short", "nc"))

\S4method{separate}{GRanges}(x)

\S4method{separate}{GRangesList}(x)

\S4method{combineIntoModstrings}{XString,GRanges}(
  x,
  gr,
  with.qualities = FALSE,
  quality.type = "Phred",
  stop.on.error = TRUE,
  verbose = FALSE,
  ...
)

\S4method{combineIntoModstrings}{XStringSet,GRangesList}(
  x,
  gr,
  with.qualities = FALSE,
  quality.type = "Phred",
  stop.on.error = TRUE,
  verbose = FALSE,
  ...
)

\S4method{combineIntoModstrings}{XStringSet,GRanges}(
  x,
  gr,
  with.qualities = FALSE,
  quality.type = "Phred",
  stop.on.error = TRUE,
  verbose = FALSE,
  ...
)

\S4method{combineModifications}{GRanges}(gr)

\S4method{combineModifications}{GRangesList}(gr)

\S4method{incompatibleModifications}{GRanges,XString}(gr, x)

\S4method{incompatibleModifications}{GRanges,XStringSet}(gr, x)

\S4method{incompatibleModifications}{GRangesList,XStringSet}(gr, x)

\S4method{removeIncompatibleModifications}{GRanges,XString}(gr, x)

\S4method{removeIncompatibleModifications}{GRanges,XStringSet}(gr, x)

\S4method{removeIncompatibleModifications}{GRangesList,XStringSet}(gr, x)
}
\arguments{
\item{x}{For \code{separate}: a \code{ModString}/\code{ModStringSet} or 
\code{GRanges}/\code{GRangesList}object

For \code{combineIntoModstrings}: a \code{XString} and a \code{XStringSet} 
object.}

\item{nc.type}{the type of nomenclature to be used. Either "short" or "nc".
"Short" for m3C would be "m3C", "nc" for m3C would be "3C". (
\code{default = "short"})}

\item{gr}{a GRanges object}

\item{with.qualities}{\code{TRUE} or \code{FALSE} (default): Should the 
values from a \code{score} column of the \code{GRanges} object stored? If
set \code{with.qualities = TRUE}, \code{combineIntoModstrings} will try to
construct a \code{\link{QualityScaledModStringSet}} object.}

\item{quality.type}{the type of \code{QualityXStringSet} used, if 
\code{with.qualities = TRUE}. Must be on of the following values: 
\code{"Phred","Solexa","Illumina"}.}

\item{stop.on.error}{For \code{combineIntoModstrings}: \code{TRUE}(default)
or \code{FALSE}: Should an error be raised upon encounter of incompatible 
positions?}

\item{verbose}{For \code{combineIntoModstrings}: \code{TRUE} or \code{FALSE}
(default): Should verbose information reported on the positions filled with 
modifications? This settings is passed onto \code{\link{modifyNucleotides}}.}

\item{...}{\code{default.quality}: for \code{combineIntoModstrings}: the 
\code{default.quality} default value for non-modified positions. (default: 
\code{default.quality = 0L})}
}
\value{
for \code{separate} a \code{GRanges} object and for 
\code{combineIntoModstrings} a \code{ModString*} object or a 
\code{QualityScaledModStringSet}, if \code{with.qualities = TRUE}.
}
\description{
With \code{combineIntoModstrings} and \code{separate} the construction and 
deconstruction of ModString Objects from an interacive session avoiding 
problematic encoding issues. In addition, modification information can be 
transfered from/to tabular data with these functions.

\code{combineIntoModstrings} expects \code{seqnames(gr)} or \code{names(gr)} 
to match the available \code{names(x)}. Only information with strand 
information \code{*} and \code{+} are used.

\code{separate} when used with a \code{GRanges}/\code{GRangesList} object
will return an object of the same type, but with modifications seperated. For
example an element with \code{mod = "m1Am"} will be returned as two elements
with \code{mod = c("Am","m1A")}. The reverse operation is available via
\code{combineModifications()}.

\code{removeIncompatibleModifications} filters incompatible modification from
a \code{GRanges} or \code{GRangesList}. \code{incompatibleModifications()} 
returns the logical vector used for this operation.
}
\examples{
library(GenomicRanges)
# ModDNAString
seq <- ModDNAString(paste(alphabet(ModDNAString()), collapse = ""))
seq

gr <- separate(seq)
gr

seq2 <- combineIntoModstrings(as(seq,"DNAString"),gr)
seq2

seq == seq2
# ModRNAString
seq <- ModRNAString(paste(alphabet(ModRNAString()), collapse = ""))
seq

gr <- separate(seq)
gr

# Separating RNA modifications
gr <- gr[1]
separate(gr)

# ... and combine them again (both operations work only on a subset of
# modifications)
combineModifications(separate(gr))

# handling incompatible modifications
seq <- RNAString("AGCU")
gr <- GRanges(c("chr1:1:+","chr1:2:+"),mod="m1A")
incompatibleModifications(gr,seq)

#
removeIncompatibleModifications(gr,seq)
}
