% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modstrings-MaskedModString.R
\name{MaskedModString}
\alias{MaskedModString}
\alias{seqtype,MaskedModString-method}
\title{MaskedModString objects}
\usage{
\S4method{seqtype}{MaskedModString}(x)
}
\arguments{
\item{x}{a \code{ModString} object.}
}
\value{
a \code{MaskedModString} object.
}
\description{
The functions are implemented as defined in the Biostrings package. Have
a look the \code{\link[Biostrings:MaskedXString-class]{MaskedXString}} class.
}
\examples{
# Mask positions
mask <- Mask(mask.width=5, start=c(2), width=c(3))
mr <- ModRNAString("ACGU7")
mr

masks(mr) <- mask
mr

# Invert masks
mr <- gaps(mr)
mr

# Drop the mask
masks(mr) <- NULL
mr
}
