% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-PennParam.R
\name{PennParam}
\alias{PennParam}
\alias{show,PennParam-method}
\title{Constructor for class \code{PennParam}}
\usage{
PennParam(
  states,
  referenceState = "222",
  prLessLikelyCN = 9e-04,
  prNonMendelian = 1.5e-06,
  prInitialStateNotDiploid = 4/5,
  prTransitionToNewState = 0.5,
  tauNM = 0.01
)

\S4method{show}{PennParam}(object)
}
\arguments{
\item{states}{character vector of possible trio states}

\item{referenceState}{the reference (normal) trio copy number state (typically '222')}

\item{prLessLikelyCN}{as defined in Wang et al. 2007, this is the probability of the less likely allele-specific copy numbers for the trio}

\item{prNonMendelian}{the prior probability of a non-Mendelian copy number alteration}

\item{prInitialStateNotDiploid}{initial probability for non-diploid states}

\item{prTransitionToNewState}{probability of transitioning to a new state}

\item{tauNM}{probability of transitioning from a Mendelian given previous event was non-Mendelian (and vice versa).}

\item{object}{a \code{PennParam} object}
}
\description{
Parameters for the PennCNV Hidden Markov model
}
\references{
Wang et al., Genome Res. 2007 Nov;17(11):1665-74.  PMID: 17921354
}
