% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichCOG.R
\name{enrichCOG}
\alias{enrichCOG}
\title{COG enrichment analysis for microbiome data}
\usage{
enrichCOG(
  gene,
  dtype = "category",
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe = NULL,
  minGSSize = 10,
  maxGSSize = 500,
  qvalueCutoff = 0.2
)
}
\arguments{
\item{gene}{a vector of COG ids.}

\item{dtype}{one of "category", "pathway"}

\item{pvalueCutoff}{adjusted pvalue cutoff on enrichment tests to report.}

\item{pAdjustMethod}{one of "holm","hochberg","hommel","bonferroni","BH",
"BY","fdr","none".}

\item{universe}{universe background genes. If missing,use the all COGs.}

\item{minGSSize}{minimal size of genes annotated by KEGG term for testing.}

\item{maxGSSize}{maximal size of genes annotated for testing.}

\item{qvalueCutoff}{qvalue cutoff on enrichment tests to report.}
}
\value{
A \code{enrichResult} instance.
}
\description{
COG enrichment analysis for microbiome data
}
\examples{

data(Psoriasis_data)
cog <- enrichCOG(Psoriasis_data,dtype="category")

}
