\name{standardise2}
\alias{standardise2}
\title{Standardization in regards to  selected time-point }
\description{Standardisation of the expression values of every gene
  is performed, so that the expression values at a chosen time point
  are zero and the standard deviation of expression profiles of
  individual genes/transcripts/proteins is one.}

\usage{standardise2(eset,timepoint=1)}
\arguments{\item{eset}{object of the class \emph{ExpressionSet}.}
\item{timepoint}{integer:  which time point should have expression
values of zero.}
}
  
\value{The function produces an object of the \emph{ExpressionSet} class with
  standardised expression values.}


\note{Mfuzz assumes that the given expression data are preprocessed
(including the normalisation). The function \code{standardise2} does not
replace the normalisation step. Note the difference: Normalisation is carried
out to make different samples comparable, while standardisation (in Mfuzz)
is carried out to make transcripts (genes) comparable.}

\author{Matthias E. Futschik  (\url{http://www.sysbiolab.eu})}

\examples{
if (interactive()){
data(yeast)
# Data pre-processing
yeastF <- filter.NA(yeast)
yeastF <- fill.NA(yeastF)
yeastF <- standardise2(yeastF,timepoint=1)

# Soft clustering and visualisation
cl <- mfuzz(yeastF,c=20,m=1.25)
mfuzz.plot(yeastF,cl=cl,mfrow=c(4,5))
}
}

\keyword{utilities}
