% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORA_hypergeometric.R
\name{ORA_hypergeometric}
\alias{ORA_hypergeometric}
\title{OverRepresentationAnalysis with a hypergeometric model}
\usage{
ORA_hypergeometric(
  background,
  annotations,
  data,
  IDs,
  tested_column = "middle_hierarchy"
)
}
\arguments{
\item{background}{dataframe that contains
KEGG IDs of metabolites that are assigned to functional modules, is incorporated
in the package \link{modules_compounds}}

\item{annotations}{dataframe tha contains information to which functional
modules our experimental metabolites are annotated in KEGG, can be constructed
by filtering the provided KEGG background \link{modules_compounds} for the experimental
metabolites}

\item{data}{result of \code{\link[=cluster_dynamics]{cluster_dynamics()}} function: either a list of data
frames or a SummarizedExperiment object}

\item{IDs}{dataframe with two columns 'metabolite' and 'KEGG' mapping KEGG IDs to metabolites.
If function \code{\link[=get_ORA_annotations]{get_ORA_annotations()}} is used to retrieve IDs these are stored under
"KEGG_annotations" of metadata(data)}

\item{tested_column}{column that is in background and annotations and on
which the hypergeometric model will be executed}
}
\value{
a dataframe containing the ORA results or if data is SummarizedExperiment \link[SummarizedExperiment]{SummarizedExperiment}
object the output is stored in metadata(data) under "ORA_tested_column"
}
\description{
Testing the hypothesis that certain KEGG modules are over-represented in
clusters of metabolites.
A module is considered over-represented in a cluster the number of
metabolites in a cluster being annotated to a functional module (n_obs)
is higher than the expected number of metabolites in a cluster of this size
being annotated to a functional module (n_theo).
We can calculate the OvE (Observed versus Expected = n_obs/n_theo) and show the
probabilities of these ratios.
log(p(OvE))>0 indicates an over-representation of the functional module in
the cluster, log(p(OvE))<0 an under-representation.
}
\examples{
data("longitudinalMetabolomics")
data("modules_compounds")
head(modules_compounds)
data("metabolite_modules")
head(metabolite_modules)
data("IDs")
head(IDs)

longitudinalMetabolomics <- ORA_hypergeometric(
  data = longitudinalMetabolomics,
  annotations = metabolite_modules,
  background = modules_compounds,
  IDs = IDs,
  tested_column = "middle_hierarchy"
)
S4Vectors::metadata(longitudinalMetabolomics)[["ORA_middle_hierarchy"]]

}
\seealso{
Function to obtain data \code{\link[=cluster_dynamics]{cluster_dynamics()}}
Function to visualize ORA results \code{\link[=plot_ORA]{plot_ORA()}}

\code{\link[=get_ORA_annotations]{get_ORA_annotations()}}
}
