% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowHC.R
\name{flowHC}
\alias{flowHC}
\title{Cluster cytometry data using hierarchical clustering}
\usage{
flowHC(fcsFrame, excludeClusterParameters, minimumClusterSizePercent = 0.05)
}
\arguments{
\item{fcsFrame}{A flow frame.}

\item{excludeClusterParameters}{A vector specifying the name of markers not
to be used for clustering.}

\item{minimumClusterSizePercent}{A number between 0 and 1, used to specify
the minimum size of a cluster relative to all events.}
}
\value{
A list of clusters. Each cluster contains the ID of all cells that
  belong to the cluster.
}
\description{
A function that cluster cytometry data using hierarchical clustering.
}
\examples{
# Find fcs files
files=system.file("extdata","SDY420/ResultFiles/CyTOF_result",
                 package="MetaCyto")
files=list.files(files,pattern="fcs$",full.names=TRUE)
# Preprocess
fcs = preprocessing(fcsFiles=files,assay ="CyTOF",b=1/8)
# cluster using flowHC
cluster_list=flowHC(fcsFrame=fcs,
                    excludeClusterParameters=c("Time","Cell_length"))
}
