% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{statistical}
\alias{statistical}
\title{Create an `AdjacencyMatrix` object containing assays of adjacency 
matrices from statistical methods}
\usage{
statistical(x, model, ...)
}
\arguments{
\item{x}{`matrix` that contains intensity values of
features/metabolites (rows) per sample (columns).}

\item{model}{`character` vector containing the methods that will be used
(`"lasso"`, `"randomForest"`, `"clr"`, `"aracne"`, `"pearson"`,
`"pearson_partial"`, `"spearman"`, `"spearman_partial"`, `ggm`, `"bayes"`)}

\item{...}{parameters passed to the functions  `lasso`, `randomForest`,
`clr`, `aracne`, `correlation` and/or `bayes`}
}
\value{
`AdjacencyMatrix` containing the respective adjacency matrices in the
`assay` slot as specified by `model`
}
\description{
The function `statitical` infers adjacency matrix topologies from
statistical methods and returns matrices of these networks in an
`AdjacencyMatrix` object. The
function includes functionality to calculate adjacency matrices based on
LASSO (L1 norm)-regression, random forests, context likelihood of
relatedness (CLR), the algorithm for the reconstruction of accurate
cellular networks (ARACNE), Pearson correlation (also partial), 
Spearman correlation (also partial)
and score-based structure learning (Bayes). The function returns an
`AdjacencyMatrix` object of adjacency matrices that are defined by `model`.
}
\details{
The function `statistical` includes functionality to calculate adjacency
matrices based on
LASSO (L1 norm)-regression, random forests, context likelihood of
relatedness (CLR), the algorithm for the reconstruction of accurate
cellular networks (ARACNE), Pearson correlation (also partial), 
Spearman correlation (also partial) and Constraint-based structure learning 
(Bayes).

`statistical` calls the function
`lasso`, `randomForest`, `clr`, `aracne`,
`correlation` (for `"pearson"`, `"pearson_partial"`, `"spearman"`, 
`"spearman_partial"`, `"ggm"`) and/or `bayes`
as specified by `model`. It will create adjacency matrices using the
specified methods and will return an `AdjacencyMatrix` containing the weighted
adjacency matrices in the `assays` slot.

Internally `x` will be z-scaled and the z-scaled object
will be used in `lasso`, `clr` and/or `aracne`.

The slot `type` is set to `statistical`. The slot `directed` is set to
`TRUE` if the methods `"lasso"`, `"randomForest"`, or `"bayes"` were used, 
otherwise `directed` is set to `FALSE`.
The slot `threshold` is set to `FALSE`.
}
\examples{
data("x_test", package = "MetNet")
x <- x_test[1:10, 3:ncol(x_test)]
x <- as.matrix(x)
statistical(x = x, model = c("pearson", "spearman"))
statistical(x = x, model = c("pearson", "spearman"), p.adjust = "BH")

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
