% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{.AdjacencyMatrix}
\alias{.AdjacencyMatrix}
\title{Create S4 class AdjacencyMatrix}
\value{
class generator function for class `AdjacencyMatrix`
}
\description{
The class `AdjacencyMatrix` extends the `SummarizedExperiment` class. It 
will add the slots `type`, `directed`, and `thresholded`.
}
\details{
The slot `type` is of type `"character"`, storing the type of the 
`"AdjacencyMatrix"`, i.e. `"structural"`, `"statistical"`, or `"combined"`.
The slot `directed` is of type `"logical"`, storing if the adjacency matrix
is directed or not.
The slot `thresholded` is of type `"logical"`, storing if the adjacency 
matrix was thresholded, e.g. if the functions `rtCorrection` or `threshold`
were applied on the `structural` or `statistical` `AdjacencyMatrix` objects.

If any of the `AdjacencyMatrix` objects passed to the `combine` function
was `directed = TRUE` or `thresholded = TRUEs` the `combine` 
`AdjacencyMatrix` object will be `directed = TRUE` or `thresholded = TRUE`.
}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
