% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/annotation_source_class.R
\name{vertical_join}
\alias{vertical_join}
\alias{vertical_join,annotation_source,annotation_source-method}
\alias{vertical_join,list,missing-method}
\title{Join sources vertically}
\usage{
vertical_join(x, y, ...)

\S4method{vertical_join}{annotation_source,annotation_source}(
  x,
  y,
  matching_columns = NULL,
  keep_cols = NULL,
  source_col = "annotation_source",
  exclude_cols = NULL,
  as = annotation_source()
)

\S4method{vertical_join}{list,missing}(
  x,
  y,
  matching_columns = NULL,
  keep_cols = NULL,
  source_col = "annotation_source",
  exclude_cols = NULL,
  as = annotation_source()
)
}
\arguments{
\item{x}{an \code{annotation_source} object}

\item{y}{an second \code{annotation_source} object to join with the first}

\item{...}{additional inputs (not currently used)}

\item{matching_columns}{(list) a named list of column names that all contain
the same information. All columns named in the same list element will be
merged into a single column with the same name as the list element.}

\item{keep_cols}{(character) a list of column names to keep in the final
joined table. All other columns will be dropped.}

\item{source_col}{(character) the name of a new column that will contain the
tags of the original source object for each row in the joined table.}

\item{exclude_cols}{(character) the names of columns to exclude from the
joined table.}

\item{as}{(character) the type of object the joined table should be returned
as e.g. "lcms_table".}
}
\value{
an \code{annotation_source} object
}
\description{
A function to join sources vertically. A vertical join involves matching
common columns across source data.frames and padding missing columns to
create a single new data.frame with data and records from multiple sources.
}
\examples{

M <- annotation_source(data = data.frame(id = 1, value = "A"))
N <- annotation_source(data = data.frame(id = 2, value = "B"))
O <- vertical_join(M, N, keep_cols = ".all")

}
