% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_columns_class.R
\name{rename_columns}
\alias{rename_columns}
\title{Select columns}
\usage{
rename_columns(expression, ...)
}
\arguments{
\item{expression}{(call) A valid rlang::expr for tidy evaluation e.g.
\code{expression = all_of(c("foo"="bar"))} will rename the column named
"bar" and "foo".  .}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{rename_columns} object with the following
\code{output} slots:
\tabular{ll}{
\code{updated} \tab (annotation_source) The updated annotations as an
\code{annotation_source} object. \cr
}
}
\description{
A wrapper around \code{\link[dplyr:rename]{dplyr::rename}}. Rename columns from
an annotation table using tidy grammar.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{tidyselect}} \item{\code{rlang}}}
}
\section{Inheritance}{

A \code{rename_columns} object inherits the following \code{struct} classes:
\cr\cr
\verb{[rename_columns]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- rename_columns(
        expression = call("example"))

}
\references{
Henry L, Wickham H (2024). \emph{tidyselect: Select from a Set
of Strings}. doi:10.32614/CRAN.package.tidyselect
\url{https://doi.org/10.32614/CRAN.package.tidyselect}, R package version
1.2.1, \url{https://CRAN.R-project.org/package=tidyselect}.

Henry L, Wickham H (2025). \emph{rlang: Functions for Base
Types and Core R and 'Tidyverse' Features}.
doi:10.32614/CRAN.package.rlang
\url{https://doi.org/10.32614/CRAN.package.rlang}, R package version
1.1.6, \url{https://CRAN.R-project.org/package=rlang}.
}
