% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/annotation_source_class.R
\name{check_for_columns}
\alias{check_for_columns}
\alias{check_for_columns,annotation_source-method}
\title{Check for columns in an \code{annotation_source}}
\usage{
check_for_columns(obj, ..., msg = FALSE)

\S4method{check_for_columns}{annotation_source}(obj, ..., msg = FALSE)
}
\arguments{
\item{obj}{an \code{\link[=annotation_source]{annotation_source()}} object}

\item{...}{the column names to check for}

\item{msg}{TRUE/FALSE indicates whether to return a message if some columns
are missing. If \code{msg = FALSE} then the function returns FALSE if all columns
are not present.}
}
\value{
logical if all columns are present, or a vector of messages if
requested.
}
\description{
This method checks for the presence of columns by name in an
\code{\link[=annotation_source]{annotation_source()}}. It returns TRUE if all are present, or a vector
of messages indicating which columns are missing from the data.frame. It is
used by MetMashR to ensure validity of certain objects.
}
\examples{
# test if column present
AT <- annotation_source(data = data.frame(id = character(0)))
check_for_columns(AT, "id") # TRUE
check_for_columns(AT, "cake") # FALSE

# return a message if missing
check_for_columns(AT, "cake", msg = TRUE)

}
