% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PathBank_metabolite_database_class.R
\name{PathBank_metabolite_database}
\alias{PathBank_metabolite_database}
\title{PathBank_metabolite_database}
\usage{
PathBank_metabolite_database(
  version = "primary",
  bfc_path = NULL,
  resource_name = "MetMashR_PathBank",
  ...
)
}
\arguments{
\item{version}{(character) PathBank version. Allowed values are
limited to the following: \itemize{ \item{\code{""}: The version of
the PatchBank database to import. To prevent unecessary downloads
\code{BiocFileCache} is used to store a local
copy.}\item{\code{"complete"}: The complete PathBank metabolite
database.}\item{\code{"primary"}: The PathBank metabolite database
for primary pathways only.}} The default is \code{"primary"}.}

\item{bfc_path}{(character, NULL) \code{BiocFileCache} is used to cache
the database locally and prevent unnecessary downloads. If a path is
provided then \code{BiocFileCache} will use this location. If NULL it will
use the default location (see \code{\link[BiocFileCache:BiocFileCache-class]{BiocFileCache::BiocFileCache()}} for
details). The default is \code{NULL}.}

\item{resource_name}{(character) The name given to this resource in
the cache. (see \code{\link[BiocFileCache:BiocFileCache-class]{BiocFileCache::BiocFileCache()}} for details). The
default is \code{"MetMashR_PathBank"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
PathBank_metabolite_database
} object. This object has no \code{output} slots.
}
\description{
Imports the PathBank database (https://pathbank.org/) of
metabolites linked to pathways.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{BiocFileCache}} \item{\code{httr}}}
}
\section{Inheritance}{

A \code{PathBank_metabolite_database} object inherits the following
\code{struct} classes: \cr\cr
\verb{[PathBank_metabolite_database]} -> \verb{[BiocFileCache_database]} ->
\verb{[annotation_database]} -> \verb{[annotation_source]} -> \verb{[struct_class]}
}

\examples{
M <- PathBank_metabolite_database(
        version = "primary",
        bfc_path = NULL,
        resource_name = "bfc",
        bfc_fun = function(){},
        import_fun = function(){},
        offline = FALSE,
        tag = character(0),
        data = data.frame(),
        source = "ANY")

}
\references{
Shepherd L, Morgan M (2025). \emph{BiocFileCache: Manage Files
Across Sessions}. doi:10.18129/B9.bioc.BiocFileCache
\url{https://doi.org/10.18129/B9.bioc.BiocFileCache}, R package version
2.99.6, \url{https://bioconductor.org/packages/BiocFileCache}.

Wickham H (2023). \emph{httr: Tools for Working with URLs and
HTTP}. doi:10.32614/CRAN.package.httr
\url{https://doi.org/10.32614/CRAN.package.httr}, R package version
1.4.7, \url{https://CRAN.R-project.org/package=httr}.

Wishart, S D, Li, Carin, Marcu, Ana, Badran, Hasan, Pon,
Allison, Budinski, Zachary, Patron, Jonas, Lipton, Debra, Cao, Xuan,
Oler, Eponine, Li, Krissa, Paccoud, Maïlys, Hong, Chelsea, Guo, C A,
Chan, Christopher, Wei, William, Ramirez-Gaona, Miguel (2019).
"PathBank: a comprehensive pathway database for model organisms."
\emph{Nucleic Acids Research}, \emph{48}, D470-D478. doi:10.1093/nar/gkz861
\url{https://doi.org/10.1093/nar/gkz861}.
}
