% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingFunctions.R
\name{plotCircos}
\alias{plotCircos}
\title{Circular plot to visualize similarity}
\usage{
plotCircos(
  groupname,
  linkDf,
  initialize = c(TRUE, FALSE),
  featureNames = c(TRUE, FALSE),
  cexFeatureNames = 0.3,
  groupSector = c(TRUE, FALSE),
  groupName = c(TRUE, FALSE),
  links = c(TRUE, FALSE),
  highlight = c(TRUE, FALSE),
  colour = NULL,
  transparency = 0.2
)
}
\arguments{
\item{groupname}{\code{character} vector containing \code{"group"} and 
\code{"name"} to display that is a unique identifier of the features, 
\code{"group"} and \code{"name"} have to be separated
by \code{"_"} where \code{"group"} is the first and \code{"name"} is the 
last element}

\item{linkDf}{\code{data.frame} containing linked features in each row, has
five columns (\code{group1}, \code{spectrum1}, \code{group2}, 
\code{spectrum2}, \code{similarity})}

\item{initialize}{\code{logical}, should plot be initialized?}

\item{featureNames}{\code{logical}, should feature names be displayed?}

\item{cexFeatureNames}{\code{numeric} size of feature names}

\item{groupSector}{\code{logical}, should groups be displayed with background
colours?}

\item{groupName}{\code{logical}, should group names (e.g. compartment names 
or individual names) be displayed?}

\item{links}{\code{logical}, should links be plotted?}

\item{highlight}{\code{logical}, \code{highlight} is set to \code{TRUE} 
by default}

\item{colour}{\code{NULL} or \code{character}, \code{colour} defines the 
colours which are used for plotting, if \code{NULL} default colours are used}

\item{transparency}{\code{numeric}, defines the transparency of the colours}
}
\value{
The function will initialize a circlize plot and/or will plot
features of a circlize plot.
}
\description{
Circular plot to visualize similarity.
}
\details{
Internal use for \code{shinyCircos} or used outside of
\code{shinyCircos} to reproduce figure
}
\examples{
library("MsCoreUtils")
data("spectra", package = "MetCirc")

## create similarity matrix
similarityMat <- Spectra::compareSpectra(sps_tissue[1:10],
    FUN = MsCoreUtils::ndotproduct, ppm = 20, m = 0.5, n = 2)
rownames(similarityMat) <- colnames(similarityMat) <- sps_tissue$name[1:10]

## order similarityMat according to retentionTime
simM <- orderSimilarityMatrix(similarityMat, sps = sps_tissue[1:10],
            type = "retentionTime")
            
## create link data.frame
linkDf <- createLinkDf(similarityMatrix = simM, sps = sps_tissue,
     condition = c("SPL", "LIM", "ANT", "STY"), lower = 0.01, upper = 1)
## cut link data.frame (here: only display links between groups)
linkDf_cut <- cutLinkDf(linkDf, type = "inter")

## set circlize paramters
circos.clear()
circos.par(gap.degree = 0, cell.padding = c(0.0, 0, 0.0, 0),
         track.margin = c(0.0, 0))
groupname <- c(as.character(linkDf_cut[, "spectrum1"]),
                as.character(linkDf_cut[, "spectrum2"]))
groupname <- unique(groupname)

## actual plotting
plotCircos(groupname, linkDf_cut, initialize = TRUE,
    featureNames = TRUE, cexFeatureNames = 0.3, groupSector = TRUE,
    groupName = FALSE, links = FALSE, highlight = FALSE, colour = NULL,
    transparency = 0.2)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
