% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{getMafRef}
\alias{getMafRef}
\alias{getMafRef,Maf-method}
\title{getMafRef}
\usage{
getMafRef(object)

\S4method{getMafRef}{Maf}(object)
}
\arguments{
\item{object}{An object of Maf}
}
\value{
Human reference genome versions of Maf
}
\description{
getMafRef
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
getMafRef(maf$V402)
}
