% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareCCF.R
\name{compareCCF}
\alias{compareCCF}
\title{compareCCF}
\usage{
compareCCF(
  maf,
  patient.id = NULL,
  min.ccf = 0,
  pairByTumor = FALSE,
  use.tumorSampleLabel = FALSE,
  ...
)
}
\arguments{
\item{maf}{Maf or MafList object generated by \code{\link{readMaf}} function.}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included.}

\item{min.ccf}{The minimum value of CCF. Default 0.}

\item{pairByTumor}{Pair by tumor types in each patients. Default FALSE.}

\item{use.tumorSampleLabel}{Logical (Default: FALSE). 
Rename the 'Tumor_Sample_Barcode' by 'Tumor_Sample_Label'.}

\item{...}{Other options passed to \code{\link{subMaf}}}
}
\value{
a result list of CCF comparing between samples/tumor pairs
}
\description{
Compare the CCF between samples/tumor pairs
This function requires CCF for clustering
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
compareCCF(maf)
}
