% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cna2gene.R
\name{cna2gene}
\alias{cna2gene}
\title{cna2gene}
\usage{
cna2gene(seg, txdb, min.overlap.len = 50, geneList = NULL)
}
\arguments{
\item{seg}{seg object generated by \code{\link{readSegment}} function.}

\item{txdb}{A TxDb object. i.e., TxDb.Hsapiens.UCSC.hg19.knownGene. Default NULL.}

\item{min.overlap.len}{The minimum insertion size of segment and gene. Default 50.}

\item{geneList}{The list of genes used to limit the annotation.Default NULL.}
}
\value{
seg object
}
\description{
cna2gene
}
\examples{
segFile <- system.file("extdata", "CRC_HZ.seg.txt", package = "MesKit")
gisticAmpGenesFile <- system.file("extdata", "COREAD_amp_genes.conf_99.txt", package = "MesKit")
gisticDelGenesFile <- system.file("extdata", "COREAD_del_genes.conf_99.txt", package = "MesKit")
gisticAllLesionsFile <- system.file("extdata", "COREAD_all_lesions.conf_99.txt", package = "MesKit")
seg <- readSegment(segFile = segFile,
                   gisticAmpGenesFile = gisticAmpGenesFile,
                    gisticDelGenesFile = gisticDelGenesFile, 
                   gisticAllLesionsFile = gisticAllLesionsFile)
                   
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(org.Hs.eg.db)
cna2gene(seg, txdb = TxDb.Hsapiens.UCSC.hg19.knownGene)
}
