% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRidge.R
\name{getRidge}
\alias{getRidge}
\title{Identify ridges based on the local maximum matrix}
\usage{
getRidge(
  localMax,
  iInit = ncol(localMax),
  step = -1,
  iFinal = 1,
  minWinSize = 5,
  gapTh = 3,
  skip = NULL,
  scaleToWinSize = "doubleodd"
)
}
\arguments{
\item{localMax}{The local maximum matrix is returned from
\code{\link[=getLocalMaximumCWT]{getLocalMaximumCWT()}} with 1 represents maximum, others are 0.}

\item{iInit}{The start column to search ridge. By default, it starts from
the coarsest scale level.}

\item{step}{Search step. -1 by default, which means searching from coarse
scale to detail scale column by column.}

\item{iFinal}{The final column index of search ridge.}

\item{minWinSize}{The minimum slide window size used.}

\item{gapTh}{The gap allowed during searching for ridge. 3 by default.}

\item{skip}{The column to be skipped during search.}

\item{scaleToWinSize}{How scales should be mapped to window sizes. Traditionally,
MassSpecWavelet used the \code{"doubleodd"} mapping (\code{winSize <- 2*scale+1}). \code{xcms} switched
this mapping to \code{"halve"} (\code{winSize <- floor(scale/2)}). Besides \code{"doubleodd"} and \code{"halve"}
this parameter can also be a custom function of the scale.}
}
\value{
Return a list of ridge. As some ridges may end at the scale larger
than 1, in order to keep the uniqueness of the ridge names, we combined the
smallest scale of the ridge and m/z index of the peak at that scale together
to name the ridges. For example the ridge name "1_653" means the peak ridge
ends at the CWT scale 1 with m/z index 653 at scale 1.
}
\description{
Identify ridges by connecting the local maximum of 2-D CWT coefficients from
the coarse scale to detail scale. The local maximum matrix is returned from
\code{\link[=getLocalMaximumCWT]{getLocalMaximumCWT()}}
}
\examples{

data(exampleMS)
scales <- seq(1, 64, 3)
wCoefs <- cwt(exampleMS[5000:11000], scales = scales, wavelet = "mexh")

localMax <- getLocalMaximumCWT(wCoefs)
ridgeList <- getRidge(localMax)
plotRidgeList(ridgeList)

}
\references{
Du, P., Kibbe, W.A. and Lin, S.M. (2006) Improved peak detection
in mass spectrum by incorporating continuous wavelet transform-based pattern
matching, Bioinformatics, 22, 2059-2065.
}
\seealso{
\code{\link[=getLocalMaximumCWT]{getLocalMaximumCWT()}}, \code{\link[=identifyMajorPeaks]{identifyMajorPeaks()}}
}
\author{
Pan Du, Simon Lin
}
\keyword{methods}
