% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_summarization_prepare.R
\name{getProcessed}
\alias{getProcessed}
\title{Get feature-level data to be used in the MSstatsSummarizationOutput function}
\usage{
getProcessed(input)
}
\arguments{
\item{input}{data.table processed by dataProcess subfunctions}
}
\value{
data.table processed by dataProcess subfunctions
}
\description{
Get feature-level data to be used in the MSstatsSummarizationOutput function
}
\examples{
raw = DDARawData 
method = "TMP"
cens = "NA"
impute = TRUE
MSstatsConvert::MSstatsLogsSettings(FALSE)
input = MSstatsPrepareForDataProcess(raw, 2, NULL)
input = MSstatsNormalize(input, "EQUALIZEMEDIANS")
input = MSstatsMergeFractions(input)
input = MSstatsHandleMissing(input, "TMP", TRUE, "NA", 0.999)
input_all = MSstatsSelectFeatures(input, "all") # all features
input_5 = MSstatsSelectFeatures(data.table::copy(input), 
"topN", top_n = 5) # top 5 features

proc1 = getProcessed(input_all)
proc2 = getProcessed(input_5)

proc1
proc2

}
