% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_normalize.R
\name{MSstatsNormalize}
\alias{MSstatsNormalize}
\title{Normalize MS data}
\usage{
MSstatsNormalize(
  input,
  normalization_method,
  peptides_dict = NULL,
  standards = NULL
)
}
\arguments{
\item{input}{data.table in MSstats format}

\item{normalization_method}{name of a chosen normalization method: "NONE" or
"FALSE" for no normalization, "EQUALIZEMEDIANS" for median normalization,
"QUANTILE" normalization for quantile normalization from `preprocessCore` package,
"GLOBALSTANDARDS" for normalization based on selected peptides or proteins.}

\item{peptides_dict}{`data.table` of names of peptides and their corresponding 
features.}

\item{standards}{character vector with names of standards, required if 
"GLOBALSTANDARDS" method was selected.}
}
\value{
data.table
}
\description{
Normalize MS data
}
\examples{
raw = DDARawData 
method = "TMP"
cens = "NA"
impute = TRUE
MSstatsConvert::MSstatsLogsSettings(FALSE)
input = MSstatsPrepareForDataProcess(raw, 2, NULL)
input = MSstatsNormalize(input, "EQUALIZEMEDIANS") # median normalization
head(input)

}
