% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataProcessPlotsTMT.R
\name{dataProcessPlotsTMT}
\alias{dataProcessPlotsTMT}
\title{Visualization for explanatory data analysis - TMT experiment}
\usage{
dataProcessPlotsTMT(
  data,
  type,
  featureName = "Transition",
  ylimUp = FALSE,
  ylimDown = FALSE,
  x.axis.size = 10,
  y.axis.size = 10,
  text.size = 2,
  text.angle = 90,
  legend.size = 7,
  dot.size.profile = 2,
  ncol.guide = 5,
  width = 10,
  height = 10,
  which.Protein = "all",
  originalPlot = TRUE,
  summaryPlot = TRUE,
  address = "",
  isPlotly = FALSE
)
}
\arguments{
\item{data}{the output of \code{\link{proteinSummarization}} function. It is a list with data frames `FeatureLevelData` and `ProteinLevelData`}

\item{type}{choice of visualization. "ProfilePlot" represents profile plot of log intensities across MS runs.
"QCPlot" represents box plots of log intensities across channels and MS runs.}

\item{featureName}{for "ProfilePlot" only, "Transition" (default) means 
printing feature legend in transition-level; "Peptide" means printing feature 
legend in peptide-level; "NA" means no feature legend printing.
FALSE(Default) for Profile Plot and QC Plot uses the upper limit as rounded off maximum of log2(intensities) after normalization + 3..}

\item{ylimUp}{upper limit for y-axis in the log scale.}

\item{ylimDown}{lower limit for y-axis in the log scale. FALSE(Default) for Profile Plot and QC Plot uses 0..}

\item{x.axis.size}{size of x-axis labeling for "Run" and "channel in Profile Plot and QC Plot.}

\item{y.axis.size}{size of y-axis labels. Default is 10.}

\item{text.size}{size of labels represented each condition at the top of Profile plot and QC plot. Default is 4.}

\item{text.angle}{angle of labels represented each condition at the top of Profile plot and QC plot. Default is 0.}

\item{legend.size}{size of legend above Profile plot. Default is 7.}

\item{dot.size.profile}{size of dots in Profile plot. Default is 2.}

\item{ncol.guide}{number of columns for legends at the top of plot. Default is 5.}

\item{width}{width of the saved pdf file. Default is 10.}

\item{height}{height of the saved pdf file. Default is 10.}

\item{which.Protein}{Protein list to draw plots. List can be names of Proteins or order numbers of Proteins.
Default is "all", which generates all plots for each protein. For QC plot, "allonly" will generate one QC plot with all proteins.}

\item{originalPlot}{TRUE(default) draws original profile plots, without normalization.}

\item{summaryPlot}{TRUE(default) draws profile plots with protein summarization for each channel and MS run.}

\item{address}{the name of folder that will store the results. Default folder is the current working directory.
The other assigned folder has to be existed under the current working directory.
An output pdf file is automatically created with the default name of "ProfilePlot.pdf" or "QCplot.pdf".
The command address can help to specify where to store the file as well as how to modify the beginning of the file name.
If address=FALSE, plot will be not saved as pdf file but showed in window.}

\item{isPlotly}{Parameter to use Plotly or ggplot2. If set to TRUE, MSstats 
will save Plotly plots as HTML files. If set to FALSE MSstats will save ggplot2 plots
as PDF files}
}
\value{
plot or pdf
}
\description{
To illustrate the quantitative data and quality control of MS runs,
dataProcessPlotsTMT takes the quantitative data  and summarized data from function `proteinSummarization` as input 
and generate two types of figures in pdf files as output :
(1) profile plot (specify "ProfilePlot" in option type), to identify the potential sources of variation for each protein;
(2) quality control plot (specify "QCPlot" in option type), to evaluate the systematic bias between MS runs and channels.
}
\examples{
data(input.pd)
quant.msstats = proteinSummarization(input.pd,
                                      method="msstats",
                                      global_norm=TRUE,
                                      reference_norm=TRUE)

## Profile plot
dataProcessPlotsTMT(data=quant.msstats,
                   type='ProfilePlot',
                   width = 21,
                   height = 7)

## NottoRun: QC plot
# dataProcessPlotsTMT(data=quant.msstats,
                    # type='QCPlot',
                    # width = 21,
                    # height = 7)
                    
}
