% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateTrypticity.R
\name{calculateTrypticity}
\alias{calculateTrypticity}
\title{Calculates level of trypticity for a list of LiP Peptides.}
\usage{
calculateTrypticity(LiP_data, fasta_file)
}
\arguments{
\item{LiP_data}{name of variable containing LiP data. Must contain at least
two columns named 'PeptideSequence' and 'ProteinName'. The values in these
column must match with what is in the corresponding FASTA file.}

\item{fasta_file}{name of variable containing FASTA data. If FASTA file has
not been processed please run the tidyFasta() function on it before inputting
into this function.}
}
\value{
a \code{data.frame} including protein, peptide, and trypticity metrics.
}
\description{
Takes as as input LiP data and a fasta file. These can be the outputs of
MSstatsLiP functions.
}
\examples{
fasta <- tidyFasta(system.file("extdata", "ExampleFastaFile.fasta", package="MSstatsLiP"))
calculateTrypticity(MSstatsLiP_data$LiP, fasta)
}
