% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeNetworksWithHTML.R
\name{generateCytoscapeConfig}
\alias{generateCytoscapeConfig}
\title{Generate Cytoscape visualization configuration}
\usage{
generateCytoscapeConfig(
  nodes,
  edges,
  display_label_type = "id",
  container_id = "network-cy",
  event_handlers = NULL,
  layout_options = NULL
)
}
\arguments{
\item{nodes}{List of nodes from getSubnetworkFromIndra}

\item{edges}{List of edges from getSubnetworkFromIndra}

\item{display_label_type}{column of nodes table for displaying node names}

\item{container_id}{ID of the HTML container element (default: 'network-cy')}

\item{event_handlers}{Optional list of event handler configurations}

\item{layout_options}{Optional list of layout configuration options}
}
\value{
List containing:
  - elements: Combined node and edge elements
  - style: Cytoscape style configuration
  - layout: Layout configuration
  - container_id: Container element ID
  - js_code: Complete JavaScript code (for backward compatibility)
}
\description{
This function creates a complete Cytoscape configuration object that can be
used to render a network visualization. It's decoupled from any specific
UI framework.
}
