% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMSData.R
\name{readMSData}
\alias{readMSData}
\alias{readMSData2}
\title{Imports mass-spectrometry raw data files as 'MSnExp'
instances.}
\usage{
readMSData(
  files,
  pdata = NULL,
  msLevel. = NULL,
  verbose = isMSnbaseVerbose(),
  centroided. = NA,
  smoothed. = NA,
  cache. = 1L,
  mode = c("inMemory", "onDisk")
)
}
\arguments{
\item{files}{A \code{character} with file names to be read and parsed.}

\item{pdata}{An object of class \linkS4class{AnnotatedDataFrame} or
\code{NULL} (default).}

\item{msLevel.}{MS level spectra to be read. In \code{inMemory} mode,
use \code{1} for MS1 spectra or any larger numeric for MSn
spectra. Default is \code{2} for \code{InMemory} mode. \code{onDisk} mode
supports multiple levels and will, by default, read all the
data.}

\item{verbose}{Verbosity flag. Default is to use
\code{\link[=isMSnbaseVerbose]{isMSnbaseVerbose()}}.}

\item{centroided.}{A \code{logical}, indicating whether spectra are
centroided or not. Default is \code{NA} in which case the information
is extracted from the raw file (for mzML or mzXML files). In
\code{onDisk}, it can also be set for different MS levels by a
vector of logicals, where the first element is for MS1, the
second element is for MS2, ... See \linkS4class{OnDiskMSnExp} for
an example.}

\item{smoothed.}{A \code{logical} indicating whether spectra already
smoothed or not. Default is \code{NA}.}

\item{cache.}{Numeric indicating caching level. Default is 0 for
MS1 and 1 MS2 (or higher). Only relevant for \code{inMemory} mode.}

\item{mode}{On of \code{"inMemory"} (default) or \code{"onDisk"}. The former
loads the raw data in memory, while the latter only generates
the object and the raw data is accessed on disk when
needed. See the \emph{benchmarking} vignette for memory and speed
implications.}
}
\value{
An \linkS4class{MSnExp} object for \code{inMemory} mode and a
\linkS4class{OnDiskMSnExp} object for \code{onDisk} mode.
}
\description{
Reads as set of XML-based mass-spectrometry data files and
generates an \linkS4class{MSnExp} object. This function uses the
functionality provided by the \code{mzR} package to access data and
meta data in \code{mzData}, \code{mzXML} and \code{mzML}.
}
\details{
When using the \code{inMemory} mode, the whole MS data is read from
file and kept in memory as \linkS4class{Spectrum} objects within the
\linkS4class{MSnExp}'es \code{assayData} slot.

To reduce the memory footpring especially for large MS1 data sets
it is also possible to read only selected information from the MS
files and fetch the actual spectrum data (i.e. the M/Z and
intensity values) only on demand from the original data
files. This can be achieved by setting \code{mode = "onDisk"}. The
function returns then an \linkS4class{OnDiskMSnExp} object instead of a
\linkS4class{MSnExp} object.
}
\note{
\code{readMSData} uses \code{normalizePath} to replace relative with
absolute file paths.
}
\examples{
file <- dir(system.file(package = "MSnbase", dir = "extdata"),
            full.name = TRUE,
            pattern = "mzXML$")
mem <- readMSData(file, mode = "inMemory")
mem
dsk <- readMSData(file, mode = "onDisk")
dsk
}
\seealso{
\code{\link[=readMgfData]{readMgfData()}} to read \code{mgf} peak lists.
}
\author{
Laurent Gatto
}
