% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{hasSpectra}
\alias{hasSpectra}
\alias{hasChromatograms}
\title{Checks if raw data files have any spectra or chromatograms}
\usage{
hasSpectra(files)

hasChromatograms(files)
}
\arguments{
\item{files}{A \code{character()} with raw data filenames.}
}
\value{
A \code{logical(n)} where \code{n == length(x)} with \code{TRUE} if that
files contains at least one spectrum, \code{FALSE} otherwise.
}
\description{
Helper functions to check whether raw files contain spectra or
chromatograms.
}
\examples{
f <- msdata::proteomics(full.names = TRUE)[1:2]
hasSpectra(f)
hasChromatograms(f)
}
\author{
Laurent Gatto
}
