% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-MSnSet.R
\name{commonFeatureNames}
\alias{commonFeatureNames}
\title{Keep only common feature names}
\usage{
commonFeatureNames(x, y)
}
\arguments{
\item{x}{An instance of class \code{\linkS4class{MSnSet}} or a
\code{list} or \code{MSnSetList} with at least 2 \code{MSnSet}
objects.}

\item{y}{An instance of class \code{\linkS4class{MSnSet}}. Ignored
if \code{x} is a \code{list}/\code{MSnSetList}.}
}
\value{
An \code{linkS4class{MSnSetList}} composed of the input
\code{MSnSet} containing only common features in the same
order. The names of the output are either the names of the
\code{x} and \code{y} input variables or the names of \code{x}
if a list is provided.
}
\description{
Subsets \code{MSnSet} instances to their common feature names.
}
\examples{
library("pRolocdata")
data(tan2009r1)
data(tan2009r2)
cmn <- commonFeatureNames(tan2009r1, tan2009r2)
names(cmn)
## as a named list
names(commonFeatureNames(list(a = tan2009r1, b = tan2009r2)))
## without message
suppressMessages(cmn <- commonFeatureNames(tan2009r1, tan2009r2))
## more than 2 instance
data(tan2009r3)
cmn <- commonFeatureNames(list(tan2009r1, tan2009r2, tan2009r3))
length(cmn)
}
\author{
Laurent Gatto
}
