% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codonmat2xy.R
\name{codonmat2xy}
\alias{codonmat2xy}
\title{codonmat2xy}
\usage{
codonmat2xy(codonmat, threads = 1)
}
\arguments{
\item{codonmat}{\code{codon matrix} obtained via
\code{\link[MSA2dist]{dnastring2codonmat}} [mandatory]}

\item{threads}{number of parallel threads [default: 1]}
}
\value{
A \code{data.frame} object with the following components:\cr
\code{Codon} Codon index\cr
\code{n} number of comparison\cr
\code{SynSum} Sum of syn\cr
\code{NonSynSum} Sum of nonsyn\cr
\code{IndelSum} Sum of indels\cr
\code{SynMean} average syn per codon\cr
\code{NonSynMean} average nonsyn per codon\cr
\code{IndelMean} average indels per codon\cr
\code{CumSumSynMean} cumulative average syn per codon\cr
\code{CumSumNonSynMean} cumulative average nonsyn per codon\cr
\code{CumSumIndelMean} cumulative indels per codon\cr
}
\description{
This function calculates average behavior of each codon for all
pairwise comparisons for indels, syn, and nonsyn mutations according to
\emph{Nei and Gojobori (1986)}.
}
\examples{
## load example sequence data
data("hiv", package="MSA2dist")
#codonmat2xy(dnastring2codonmat(hiv))
hiv |> dnastring2codonmat() |> codonmat2xy()
#codonmat2xy(dnastring2codonmat(hiv), threads=2)
hiv |> dnastring2codonmat() |> codonmat2xy(threads=2)
}
\references{
Nei and Gojobori. (1986) Simple methods for estimating the
numbers of synonymous and nonsynonymous nucleotide substitutions.
\emph{Mol. Biol. Evol.}, \bold{3(5)}, 418-426.

Ganeshan et al. (1997) Human immunodeficiency virus type 1
genetic evolution in children with different rates of development of disease.
\emph{J. Virology.} \bold{71(1)}, 663-677.

Yang et al. (2000) Codon-substitution models for heterogeneous
selection pressure at amino acid sites. \emph{Genetics.}
\bold{155(1)}, 431-449.
}
\seealso{
\code{\link[MSA2dist]{dnastring2codonmat}}
\code{\link[MSA2dist]{codonmat2pnps}}
\code{\link[MSA2dist]{dnastring2kaks}}
\code{\link[seqinr]{kaks}}
}
\author{
Kristian K Ullrich
}
