#' @title hiv-data
#' @name hiv-data
#' @description Example cds sequences from HIV-1 sample 136 patient 1 from
#' Sweden envelope glycoprotein (env) gene, V3 region as \code{DNAStringSet}.
#' @importFrom Biostrings DNAStringSet
#' @references Yang et al. (2000) Codon-substitution models for heterogeneous
#' selection pressure at amino acid sites. \emph{Genetics.}
#' \bold{155(1)}, 431-449.
#' @docType data
#' @usage data(hiv)
#' @format an object of class \code{DNAStringSet}
#' see \code{\link[Biostrings]{XStringSet-class}}
#' @keywords datasets
#' @examples
#' data("hiv", package="MSA2dist")

"hiv"
