% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOSim.R
\name{mosim}
\alias{mosim}
\title{mosim}
\usage{
mosim(
  omics,
  omicsOptions,
  diffGenes,
  numberReps,
  numberGroups,
  times,
  depth,
  profileProbs,
  minMaxFC,
  TFtoGene
)
}
\arguments{
\item{omics}{Character vector containing the names of the omics to simulate,
which can be "RNA-seq", "miRNA-seq", "DNase-seq", "ChIP-seq" or
"Methyl-seq"  (e.g. c("RNA-seq", "miRNA-seq")). It can also be a list with
the omic names as names and their options as values, but we recommend to
use the argument omicSim to provide the options to simulated each omic.}

\item{omicsOptions}{List containing the options to simulate each omic. We
recommend to apply the helper method \link{omicSim} to create this list in
a friendly way, and the function \link{omicData} to provide custom data
(see the related sections for more information). Each omic may have
different configuration parameters, but the common ones are:
\describe{
    \item{simuData/idToGene}{Seed sample and association tables for
    regulatory omics. The helper function \link{omicData} should be used to
    provide this information (see the following section).}
    \item{regulatorEffect}{For regulatory omics. List containing the
    percentage of effect types (repressor, activator or no effect) over the
    total number of regulators. See vignette for more information.}
    \item{totalFeatures}{Number of features to simulate. By default, the
    total number of features in the seed dataset.}
    \item{depth}{Sequencing depth in millions of reads. If not provided,
    it takes the global parameter passed to \link{mosim} function.}
    \item{replicateParams}{List with parameters \emph{a} and \emph{b} for
    adjusting the variability in the generation of replicates using the
    negative binomial. See vignette for more information.}
 }}

\item{diffGenes}{Number of differentially expressed genes to simulate, given
in percentage (0 - 1) or in absolute number (> 1). By default 0.15}

\item{numberReps}{Number of replicates per experimetal condition (and time
point, if time series are to be generated). By default 3.}

\item{numberGroups}{Number of experimental groups or conditions to simulate.}

\item{times}{Vector of time points to consider in the experimental design.}

\item{depth}{Sequencing depth in millions of reads.}

\item{profileProbs}{Numeric vector with the probabilities to assign each of
the patterns. Defaults to 0.2 for each.}

\item{minMaxFC}{Numeric vector of length 2 with minimum and maximum fold-change
for differentially expressed features, respectively.}

\item{TFtoGene}{A logical value indicating if default transcription factors
data should be used (TRUE) or not (FALSE), or a 3 column data frame
containing custom associations. By default FALSE.}
}
\value{
Instance of class "MOSimulation" containing the multiomic simulation
  data.
}
\description{
Performs a multiomic simulation by chaining two actions: 1) Creating the
"MOSimulation" class with the provided params. 2) Calling "simulate" method on
the initialized object.
}
\examples{

 moSimulation <- mosim(
     omics = c("RNA-seq"),
     numberReps = 3,
     times = c(0, 2, 6, 12, 24)
 )

 # Retrieve simulated count matrix for RNA-seq
 dataRNAseq <- omicResults(moSimulation, "RNA-seq")


}
