% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiOmicsMethod.R
\name{summarizeWithPca}
\alias{summarizeWithPca}
\title{Summarize Using PCA}
\usage{
summarizeWithPca(
  data,
  features,
  name = "pca",
  shrink = FALSE,
  method = "regular",
  cliques = NULL,
  maxPCs = 3,
  loadThr = 0.6
)
}
\arguments{
\item{data}{a data matrix}

\item{features}{a vector with the features to analyze}

\item{name}{prefix of the covariates}

\item{shrink}{shirnk or not the covariance matrix.}

\item{method}{either 'regular', 'sparse' or 'topological'}

\item{cliques}{the features organized in cliques. Only use for topology.}

\item{maxPCs}{maximum number of pcs to consider}

\item{loadThr}{loading threshold}
}
\value{
a list with summary of the omic:
\item{x}{summary of the omic for each sample (principal components)}
\item{sdev}{standard deviation of the principal components}
\item{loadings}{loadings of PCA}
\item{usedGenes}{genes list of genes used to calculate the summary}
\item{namesCov}{names of the covariates}
\item{method}{method used for the analysis}
\item{omicName}{name of the omic}
}
\description{
Given a matrix it summarize to principal components.
The user can specify the number of principal components. Default 3.
}
